type INTERNAL__WorkflowBase<TTag extends string, TObject = never> = [TObject] extends [never] ? {
  __tag: TTag,
} : TObject & {
  __tag: TTag,
}

export type AddStatewideServiceWorkflow = INTERNAL__WorkflowBase<"ADD_SERVICE">
export type ViewStatewideServicesWorkflow = INTERNAL__WorkflowBase<"VIEW_SERVICES", { id: string }>
export type UpdateStatewideServicesWorkflow = INTERNAL__WorkflowBase<"UPDATE_SERVICE", { id: string }>
export type DeleteStatewideServicesWorkflow = INTERNAL__WorkflowBase<"DELETE_SERVICE", { id: string }>
export type ViewStatewideServicesWorkflowContent = Omit<ViewStatewideServicesWorkflow, "__tag">

export type UploadAgencyFeedWorkflow = INTERNAL__WorkflowBase<"UPLOAD_AGENCY_FEED", { id: string }>
export type DownloadAgencyFeedWorkflow = INTERNAL__WorkflowBase<"DOWNLOAD_AGENCY_FEED", { id: string }>
export type StatusAgencyFeedWorkflow = INTERNAL__WorkflowBase<"STATUS_AGENCY_FEED", { id: string }>
export type ViewAgencyFeedWorkflow = INTERNAL__WorkflowBase<"VIEW_AGENCY_FEED", { id: string }>

export type InviteNewMemberWorkflow = INTERNAL__WorkflowBase<"INVITE_NEW_MEMBER">
export type RevokeMemberPriviledgesWorkflow = INTERNAL__WorkflowBase<"REVOKE_MEMBER_PRIVILEDGES", { email: string }>

export type WorkflowOption =
  InviteNewMemberWorkflow |
  RevokeMemberPriviledgesWorkflow |
  UploadAgencyFeedWorkflow |
  DownloadAgencyFeedWorkflow |
  StatusAgencyFeedWorkflow |
  ViewAgencyFeedWorkflow |
  AddStatewideServiceWorkflow |
  ViewStatewideServicesWorkflow |
  UpdateStatewideServicesWorkflow |
  DeleteStatewideServicesWorkflow |
  undefined

export type WorkflowTag = NonNullable<WorkflowOption>["__tag"]

